<?php
/*	
	Chaosquake Land Mark System (c) by Dominic Szablewski 
	lms@chaosquake.de - chaosquake.de 
*/


//	HTML Kopf und Fuss ausgeben,  und alle weiteren Funktionen aufrufen

require_once('inc/conf.php');
require_once('inc/sql.class.php');

// Admin Header Login
$GLOBALS['LMSAdmin'] = false;
if(isset($_GET['admin'])) {
	require_once('inc/admin.func.php');
	admin_login();
}

// Admin User/Passwort berprfen
if($_SERVER['PHP_AUTH_USER'] == ADMIN_USER && $_SERVER['PHP_AUTH_PW'] == ADMIN_PASSWORD) {
	$GLOBALS['LMSAdmin']=true;
}
?>
<html>
<head>
	<link rel="stylesheet" type="text/css" href="inc/std.css">
	<script language="javascript1.1" src="inc/overdiv.js" type="text/javascript"></script>
	<title>Chaosquake Land Mark System</title>
</head>
<body>
<div id="content">
<h1>Chaosquake Land Mark System</h1>
<a href="?admin" style="float:right"><b>Admin</b></a>
<a href="?m"><b>Karte</b></a> |
<a href="?l"><b>Liste</b></a> |
<a href="?suche"><b>Suchen</b></a> |
<a href="?eintragen"><b>Eintragen</b></a>


<br/><br/>
<?php

// Suchformular
if(isset($_GET['suche']))
	include("inc/suche.html.php");
	
// Regestrierungsformular
else if(isset($_GET['eintragen'])) 
	include("inc/eintragen.html.php");
	
// Regestrierung
else if(isset($_POST['reg'])) {
	require_once('inc/reg.func.php');
	register();
}

// Eintrag lschen
else if(isset($_GET['del']) && $GLOBALS['LMSAdmin'] === true) {
	require_once('inc/admin.func.php');
	admin_delete($_GET['del']);
}

// Eintrag editieren Formular
else if(isset($_GET['edit']) && $GLOBALS['LMSAdmin'] === true) {
	require_once('inc/admin.func.php');
	admin_loadedit($_GET['edit']);
}

// Eintrag editieren
else if(isset($_POST['edit']) && $GLOBALS['LMSAdmin'] === true) {
	require_once('inc/admin.func.php');
	admin_edit();
}

// User-Liste ausgeben
else if(isset($_GET['l'])) {
	require_once('inc/list.func.php');
	$UserList=getList($_GET['l'], $_GET['s']);
	
	// Tabellenkopf
	echo '<table border="0" cellspacing="0" cellpadding="0" width="100%">';
	echo '<tr><th><a href="?l='.$_GET['l'].'&s=name">Name</a></th>
		<th><a href="?l='.$_GET['l'].'&s=plz">PLZ</a></th>
		<th><a href="?l='.$_GET['l'].'&s=ort">Ort</a></th>';
	foreach(array_keys($DataFields) AS $f)
		echo "<th>$f</th>";
	if($GLOBALS['LMSAdmin'] == true)
		echo '<th>Admin</th>';
	echo '<tr>';
	
	// Liste durchgehen
	foreach($UserList AS $User) {
		echo '<tr onMouseOver="this.bgColor=\'#efefef\';" onMouseOut="this.bgColor=\'\';">
			<td><a href="?m='.$User['id'].'">'.$User['name'].'</a></td><td>'.$User['plz'].'</td><td>'.$User['ort'].'</td>';
			
		// Zustzliche Felder
		foreach(array_keys($DataFields) AS $Field)
			echo '<td>'.$User['data'][$Field].'</td>';
			
		// Admin-Links anzeigen, wenn eingeloggt
		if($GLOBALS['LMSAdmin'] == true) {
			echo '<td><a href="?del='.$User['id'].'">del</a>&nbsp;|&nbsp;<a href="?edit='.$User['id'].'">edit</a></td>';
		}
		echo '</tr>';
	}
	echo '</table>';
}

// Karte zeichnen ( standard Aktion )
else {
	require_once('inc/map.func.php');
	echo '<div id="map"><div id="inf"></div>';
	$p=getPoints((int)$_GET['m']);
	generatePoints($p);
	echo '</div>';
}

?>

<br/><br/>

<?php 	// Das Copyright bitte nicht entfernen!	?>
Chaosquake Land Mark System (c) 2007 <a href="http://www.chaosquake.de">chaosquake.de</a>
<?php	// Das Copyright bitte nicht entfernen!	?>

</div>
</body>
</html>
