<?php
/*	
	Chaosquake Land Mark System (c) by Dominic Szablewski 
	lms@chaosquake.de - chaosquake.de 
*/


//	Funktionen zum laden und anzeigen der Karte

require_once('conf.php');
require_once('sql.class.php');



// Breitengrad in X-Pixelkoordinate umrechnen
function lon2px($lon) {
	global $City;
	return round((($lon - $City[0]['lon'])/LON_PER_PX + $City[0]['x'])/RASTER_SIZE);
}

// Lngengrad in Y-Pixelkoordinate umrechnen
function lat2px($lat) {
	global $City;
	return round((($City[0]['lat'] - $lat)/LAT_PER_PX + $City[0]['y'])/RASTER_SIZE);
}

// Eintrge aus der Datenbank laden und nach Pixelkoordinaten gruppieren
function getPoints($id=0) {
	// Suche ?
	$q = "SELECT u.name, g.lon, g.lat, g.ort FROM ".TABLE_USER." u LEFT JOIN ".TABLE_GEODB."  g ON u.geoid = g.id WHERE 1 ";
	if($id) $q .="AND u.id = '".mysql_real_escape_string($id)."' ";
	if($_GET['name']) $q .="AND u.name LIKE '%".mysql_real_escape_string($_GET['name'])."%' ";
	if($_GET['plz']) $q .="AND g.plz LIKE '".mysql_real_escape_string($_GET['plz'])."%' ";
	if($_GET['ort']) $q .="AND g.ort LIKE '".mysql_real_escape_string($_GET['ort'])."%' ";
	
	global $db;
	$res = $db->query($q);
	$p=array();
	
	// Gefundene Eintrge durchgehen
	while($row = mysql_fetch_assoc($res)) {
	
		// Lngen- und Breitengrad in Pixelkoordinaten umrechnen
		$x=lon2px($row['lon']);
		$y=lat2px($row['lat']);
	
		// Eintrag in das Array bergeben (X -> Y -> Ort -> N -> Username )
		// Durch das verwenden der X u. Y Pixelkoordinaten als Array-Keys,
		// werden mehrere Eintrge auf einem Pixel automatisch zusammengefasst
		if($x <= MAP_WIDTH && $y <= MAP_HEIGHT && $x > 0 && $y > 0)			
			$p[$x][$y][$row['ort']][] = $row['name'];
	}
	return $p;	
}

// Liste durchgehen und ausgeben
function generatePoints(&$p) {
	foreach($p AS $x => $xs) {
		foreach($xs AS $y => $ys) {
			drawPoint($x, $y, $ys);
		}
	}
}

// Punkt zeichnen
function drawPoint($x, $y, &$p) {
	$s = '';
	$usercount = 0;
	
	// Inhalt des Mouse-Over-DIVs
	foreach($p AS $ort => $user) {
		// Nicht der erste Ort fr diesen Punkt? -> Zeilenumbruch
		if($s) $s .= '<br/><br/>'; 
		
		// Ortsname
		$s .="<h2>$ort</h2>";
		
		// Usernamen
		foreach($user AS $key => $name) {
			$s.=($key?', ':' ').str_replace("'", "\\'",$name);
			$usercount++;
		}
	}
	
	// Gre des Punktes ( css-class) anhand der Anzahl der User auf diesem Punkt festlegen
	foreach($GLOBALS['UserCountClass'] as $dCount => $dClass) {
		if($usercount > $dCount || $_GET['m'])
			$cssClass = $dClass;
	}
		
	// Punkt ausgeben
	echo '<a href="?l='.$x.','.$y.'" onMouseOut="h();" onMouseOver="s(this, \''.$s.'\');" class="'.$cssClass.'" style="left:'.($x*RASTER_SIZE).'; top:'.($y*RASTER_SIZE).'"></a>'."\n";
}

?>