<?php
/*	
	Chaosquake Land Mark System (c) by Dominic Szablewski 
	lms@chaosquake.de - chaosquake.de 
*/


//	Funktionen zum laden der Tabelle

require_once('conf.php');
require_once('sql.class.php');


// Parse Funktionen fr $DataFields ( siehe conf.php )

// Link zum Irc-Channel erstellen
function parseIrc($s) {
	if(!$s) return "";
	if($s[0]=='#')
		$s=substr($s, 1);
	return "<a href=\"irc://irc.quakenet.org/$s\">#$s</a>";
}

// E-Mail-Adresse UTF8 codieren (spam schutz ... ) und Link erstellen
function parseMail($s) {
	
	$r=preg_replace( "/(.)/se", " '&#' . ord( '\\1' ) . ';' ", $s );
	return "<a href=\"mailto:$r\">$r</a>";
}



// X-Pixelkoordinate in Breitengrad umrechnen
function px2lon($px) {
	global $City;
	return ($px - $City[0]['x'])*LON_PER_PX + $City[0]['lon'];
}

// Y-Pixelkoordinate in Lngengrad umrechnen
function px2lat($px) {
	global $City;
	return ($City[0]['y'] - $px)*LAT_PER_PX + $City[0]['lat'];
}

// Userliste aus der Datenbank laden
function getList($coord, $sort) {

	// Anzeigebereich festlegen, wenn auf einen Punkt in der Karte geklickt wurde
	$a = explode(',', $coord);
	$x=(int)$a[0]*RASTER_SIZE;
	$y=(int)$a[1]*RASTER_SIZE;
	$lon_min=px2lon($x-RASTER_SIZE/2);
	$lon_max=px2lon($x+RASTER_SIZE/2);
	$lat_max=px2lat($y-RASTER_SIZE/2);
	$lat_min=px2lat($y+RASTER_SIZE/2);
	
	// Sortierreihenfolge
	if(!preg_match('/name|ort|plz/',$sort))
		$sort='name';
	
	// Suche
	if($_GET['name']) $qname="AND u.name LIKE '%".mysql_real_escape_string($_GET['name'])."%'";
	if($_GET['plz']) $qplz="AND g.plz LIKE '".mysql_real_escape_string($_GET['plz'])."%'";
	if($_GET['ort']) $qort="AND g.ort LIKE '".mysql_real_escape_string($_GET['ort'])."%'";
	
	// Bereich gegeben?
	if($x && $y) {
		$q="SELECT u.id, u.name, u.data, g.ort, g.plz FROM ".TABLE_USER." u LEFT JOIN ".TABLE_GEODB." g ON u.geoid = g.id
			WHERE g.lon >= $lon_min AND g.lon <= $lon_max
			AND g.lat >= $lat_min AND g.lat <= $lat_max
			ORDER BY $sort";
	}
	// Alle anzeigen
	else {
		$q="SELECT u.id, u.name, u.data, g.ort, g.plz FROM ".TABLE_USER." u LEFT JOIN ".TABLE_GEODB." g ON u.geoid = g.id
		WHERE 1 $qname $qplz $qort ORDER BY $sort";
	}

	global $db;
	$res=$db->query($q);
	$l=array();
	while($row = mysql_fetch_assoc($res)) {
		$row['data'] = unserialize($row['data']);
		if(is_array($row['data']))
			foreach($row['data'] AS $k => $v) // Parse Funktion fr jedes Element aufrufen
				if($GLOBALS['DataFields'][$k])
					$row['data'][$k] = $GLOBALS['DataFields'][$k]($v);
		$l[]=$row;		
	}
	return $l;	
}
?>