<?php
/*	
	Chaosquake Land Mark System (c) by Dominic Szablewski 
	lms@chaosquake.de - chaosquake.de 
*/


//	Configuration fr das Land Mark System

// Datenbank-Einstellungen
define('DB_HOST', 	'localhost');
define('DB_USER', 	'root');
define('DB_PASSWORD', 	'');
define('DB_DATABASE', 	'lms3');

// Tabellen-Namen
define('TABLE_GEODB', 	'lms_geodb');
define('TABLE_USER', 	'lms_user');

// Admin User u. Passwort ( unbedingt ndern! )
define('ADMIN_USER', 		'lmsadmin');
define('ADMIN_PASSWORD',	'lmsadmin');


// Bild-spezifische Daten ...
define('MAP_WIDTH', 	700); // Breite des Bildes
define('MAP_HEIGHT', 	900); // Hhe

// Punkte innerhalb von RASTER_SIZE Pixeln, werden zu einem Punkt zusammengefasst
// Bei wenigen Eintrgen kann dieser Wert auch auf 1 gesetzt werden, 
// um die genauigkeit ein wenig zu erhhen
define('RASTER_SIZE', 	5); 


// Zustzliche Feldnamen, sowie die dazugehrigen funktionen zum parsen dieser.
// Ist der Funktionsname leer, so wird keine Funktion aufgerufen
// FeldName => Funktionsname
$GLOBALS['DataFields'] = array( 'Irc'=>'parseIrc', 'E-Mail' => 'parseMail' );


// Dieses  Array legt fest, welche CSS-Class ab wievielen Usern verwendet wird.
// Wenn mehrere User auf einem Punkt liegen, wird dieser Punkt grer dargestellt
// Die Reihenfolge ist wichtig! Der Kleinste Usercount zuerst.

// Mehr als 0 User -> class p1;  Mehr als 1 User -> class p2; Mehr als 2 User -> class p3; Mehr als 4 User -> class p4;
$GLOBALS['UserCountClass'] = array( 0 => 'p1', 1 => 'p2', 2 => 'p3', 4 => 'p4' );



// Zwei Referenzpunkte auf der Karte
// Durch die Position der beiden Punkte, sowohl auf der Karte (in Pixel),
// als auch die tatschlichen Lnge- und Breitengraden, kann das Verhltnis 
// von Pixeln zu den tatschlichen Koordinaten ermittelt werden.
// Diese beiden Punkte sollten mglichst weit ausseinander liegen, um das Verhltnis genauer bestimmen zu knnen

// Berlin
// Position auf dem Kartenbild in Pixeln
$City[0]['x']=465- RASTER_SIZE/2; 
$City[0]['y']=242- RASTER_SIZE/2;

// Reale Koordinaten
$City[0]['lon']=13.4;
$City[0]['lat']=52.5167;


//Darmstadt
// Position auf dem Kartenbild in Pixeln
$City[1]['x']=176- RASTER_SIZE/2;
$City[1]['y']=500  - RASTER_SIZE/2;

// Reale Koordinaten
$City[1]['lon']=8.64944;
$City[1]['lat']=49.8706;


// Verhltnis errechnen - Finger weg
define('LON_PER_PX', ($City[0]['lon'] - $City[1]['lon']) / ($City[0]['x'] - $City[1]['x']));
define('LAT_PER_PX', ($City[0]['lat'] - $City[1]['lat']) / ($City[1]['y'] - $City[0]['y']));
?>